chrome.runtime.onInstalled.addListener(() => {
    console.log('Berry Ave Whitelist Tool installed');
    
    chrome.storage.local.get(['stats'], (result) => {
      if (!result.stats) {
        chrome.storage.local.set({
          stats: {
            today: 0,
            total: 0,
            session: 0,
            page: 0
          }
        });
      }
    });
  });
  
  chrome.alarms.create('resetDailyStats', {
    when: getNextMidnight(),
    periodInMinutes: 24 * 60 // Repeat every 24 hours
  });
  
  chrome.alarms.onAlarm.addListener((alarm) => {
    if (alarm.name === 'resetDailyStats') {
      chrome.storage.local.get(['stats'], (result) => {
        const stats = result.stats || {};
        stats.today = 0;
        chrome.storage.local.set({ stats });
      });
    }
  });
  
  function getNextMidnight() {
    const now = new Date();
    const midnight = new Date(now);
    midnight.setHours(24, 0, 0, 0);
    return midnight.getTime();
  }